/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* ***********************************************************************
   *                                                                     *
   * regx20.h                                                            *
   * Christoph Schmidt, BID R&D, 19. Sep. 1997                          *
   *                                                                     *
   * defines for second command byte and 16-bit commands                 *
   *                                                                     *
   ***********************************************************************
*/


#include "regxdir.h"


#define MERGE_EXEACTION_LOCK(cmd)	CMD_MERGE (CMDG_EXEACTION_LOCK, cmd)

/* BestMasterBlockPageRun() */
#define CMDM_EXE_MBLKPGRUN         0x06
#define CMD_EXE_MBLKPGRUN          MERGE_EXEACTION_LOCK (CMDM_EXE_MBLKPGRUN)
#define IN_EXE_MBLKPGRUN           1
#define OUT_EXE_MBLKPGRUN	   0

/* BestMasterBlockPageRerun() */
#define CMDM_EXE_MBLKPGRERUN         0x07
#define CMD_EXE_MBLKPGRERUN          MERGE_EXEACTION_LOCK (CMDM_EXE_MBLKPGRERUN)
#define IN_EXE_MBLKPGRERUN           1
#define OUT_EXE_MBLKPGRERUN	   0

/* Data mem. functions (requires exerciser off) */
/* BestDataMemPatternFill */
#define CMDM_DATA_MEM_PATT_FILL		0x30
#define CMD_DATA_MEM_PATT_FILL		MERGE_EXEACTION_LOCK (CMDM_DATA_MEM_PATT_FILL)
#define IN_DATA_MEM_PATT_FILL	        20 /* 4 b_int32's and a b_dmempatttype */
#define OUT_DATA_MEM_PATT_FILL		0


/* target decoder and config space commands */

/* help commands for internal use */
#define CMDM_EXE_TDEC_PREPREG_PUSH	0x40
#define CMD_EXE_TDEC_PREPREG_PUSH	MERGE_EXEACTION_LOCK (CMDM_EXE_TDEC_PREPREG_PUSH)
#define IN_EXE_TDEC_PREPREG_PUSH	 0
#define OUT_EXE_TDEC_PREPREG_PUSH	 0

#define CMDM_EXE_TDEC_PREPREG_POP	0x41
#define CMD_EXE_TDEC_PREPREG_POP	MERGE_EXEACTION_LOCK (CMDM_EXE_TDEC_PREPREG_POP)
#define IN_EXE_TDEC_PREPREG_POP		 0
#define OUT_EXE_TDEC_PREPREG_POP	 0

/* programming and reading a decoder */

#define CMDM_EXE_TDEC_READ		0x43
#define CMD_EXE_TDEC_READ		MERGE_EXEACTION_LOCK (CMDM_EXE_TDEC_READ)
#define IN_EXE_TDEC_READ		 1
#define OUT_EXE_TDEC_READ		 0

/* programming and reading a decoder's powerup properties */
#define CMDM_EXE_TDEC_PROGPU		0x44
#define CMD_EXE_TDEC_PROGPU		MERGE_EXEACTION_LOCK (CMDM_EXE_TDEC_PROGPU)
#define IN_EXE_TDEC_PROGPU		 1
#define OUT_EXE_TDEC_PROGPU		 0

#define CMDM_EXE_TDEC_READPU		0x45
#define CMD_EXE_TDEC_READPU		MERGE_EXEACTION_LOCK (CMDM_EXE_TDEC_READPU)
#define IN_EXE_TDEC_READPU		 1
#define OUT_EXE_TDEC_READPU		 0

#define CMDM_CONFIG_SCAN		0x50
#define CMD_CONFIG_SCAN		        MERGE_EXEACTION_LOCK (CMDM_CONFIG_SCAN)
#define IN_CONFIG_SCAN			 0
#define OUT_CONFIG_SCAN			 0


/* Expansion ROM */

#define CMDM_EXP_ROM_BYTE_WRITE		0xf0
#define CMD_EXP_ROM_BYTE_WRITE	MERGE_EXEACTION_LOCK (CMDM_EXP_ROM_BYTE_WRITE)
#define IN_EXP_ROM_BYTE_WRITE		 5 /* long offset, byte value */
#define OUT_EXP_ROM_BYTE_WRITE		 0

